<?php
require_once __DIR__ . '/functions.php';

// Adjust base URL for catalog page to use relative paths
$base_url = (basename($_SERVER['SCRIPT_NAME']) === 'catalog.php') ? '../' : BASE_URL;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' - ' : ''; ?>Mutalex Academy</title>
    <link rel="stylesheet" href="<?php echo $base_url; ?>assets/css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $base_url; ?>assets/js/main.js"></script>
    <?php if (isset($use_tailwind) && $use_tailwind): ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <style>
        /* Custom styles for the professional look */
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f7f9fb; /* Light background for contrast */
        }
        .text-primary-dark {
            color: #0b1c3e; /* Deep Navy Blue */
        }
        .bg-primary-dark {
            background-color: #0b1c3e;
        }
        .hover-lift:hover {
            transform: translateY(-4px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
    </style>
    <?php endif; ?>
</head>
<body>
    <header class="header">
        <?php if (!isset($use_tailwind) || !$use_tailwind): ?>
        <div class="container">
        <?php endif; ?>
            <div class="nav-wrapper <?php if (isset($use_tailwind) && $use_tailwind): ?>nav-fullwidth<?php endif; ?>">
                <button type="button" id="mobileMenuButton" class="mobile-menu-toggle" aria-controls="mobileMenu" aria-expanded="false">
                    <i class="fas fa-bars" aria-hidden="true"></i>
                </button>
                <div class="logo">
                    <a href="<?php echo $base_url; ?>home">
                        <?php
                        $siteLogo = getSiteSetting('site_logo') ?: 'fas fa-newspaper';
                        $siteName = getSiteSetting('site_name') ?: 'Mutalex Academy';

                        if (strpos($siteLogo, 'assets/images/') === 0) {
                            echo '<img src="' . $base_url . htmlspecialchars($siteLogo) . '" alt="' . htmlspecialchars($siteName) . '" class="site-logo">';
                        } else {
                            echo '<i class="' . htmlspecialchars($siteLogo) . '"></i>';
                        }
                        echo htmlspecialchars($siteName);
                        ?>
                    </a>
                </div>
                <nav class="nav">
                     <a href="<?php echo $base_url; ?>home" class="nav-link">Home</a>
                     <a href="<?php echo $base_url; ?>category?cat=news" class="nav-link">News</a>
                     <a href="<?php echo $base_url; ?>category?cat=articles" class="nav-link">Articles</a>
                     <a href="<?php echo $base_url; ?>category?cat=journals" class="nav-link">Journals</a>
                     <a href="<?php echo $base_url; ?>surveys.php" class="nav-link">Surveys</a>
                     <?php if (isLoggedIn()): ?>
                         <?php
                         // Get cart count for logged-in users
                         $cartCount = 0;
                         if (isLoggedIn()) {
                             try {
                                 $db = getDB();
                                 $userId = $_SESSION['user_id'];
                                 $stmt = $db->prepare("SELECT COUNT(*) as count FROM cart_items WHERE user_id = ? AND item_type = 'course'");
                                 $stmt->execute([$userId]);
                                 $result = $stmt->fetch(PDO::FETCH_ASSOC);
                                 $cartCount = $result['count'] ?? 0;
                             } catch (Exception $e) {
                                 $cartCount = 0;
                             }
                         }
                         ?>
                         <?php if (basename($_SERVER['SCRIPT_NAME']) !== 'home.php'): ?>
                         <button type="button" class="nav-link cart-link" data-bs-toggle="modal" data-bs-target="#cartModal" style="background: none; border: none; cursor: pointer;">
                             <i class="fas fa-shopping-cart me-1"></i>Cart
                             <?php if ($cartCount > 0): ?>
                                 <span class="cart-count"><?php echo $cartCount; ?></span>
                             <?php endif; ?>
                         </button>
                         <?php endif; ?>
                         <?php if (basename($_SERVER['SCRIPT_NAME']) !== 'home.php'): ?>
                             <a href="<?php echo $base_url; ?>profile.php" class="nav-link">Profile</a>
                         <?php endif; ?>
                         <?php if (hasRole('admin')): ?>
                             <a href="<?php echo $base_url; ?>admin/dashboard.php" class="nav-link">Admin Dashboard</a>
                         <?php elseif (hasRole('instructor')): ?>
                             <a href="<?php echo $base_url; ?>instructor/dashboard.php" class="nav-link">Instructor Dashboard</a>
                         <?php else: ?>
                             <?php renderStudentDashboardLink($base_url); ?>
                         <?php endif; ?>
                         <a href="<?php echo $base_url; ?>logout.php" class="nav-link">Logout</a>
                     <?php else: ?>
                         <a href="<?php echo $base_url; ?>login.php" class="nav-link">Login</a>
                     <?php endif; ?>
                 </nav>
             </div>
        <?php if (!isset($use_tailwind) || !$use_tailwind): ?>
        </div>
        <?php endif; ?>
    </header>

    <!-- Mobile Navigation Overlay (Hidden by default) -->
    <div id="mobileMenu" class="mobile-menu-overlay" aria-hidden="true">
        <div class="flex justify-between items-center mb-10">
            <div class="text-xl font-extrabold text-primary-dark tracking-wider">
                <?php
                $siteLogo = getSiteSetting('site_logo') ?: 'fas fa-newspaper';
                $siteName = getSiteSetting('site_name') ?: 'Mutalex Academy';

                if (strpos($siteLogo, 'assets/images/') === 0) {
                    echo '<img src="' . $base_url . htmlspecialchars($siteLogo) . '" alt="' . htmlspecialchars($siteName) . '" class="h-8 w-8 mr-2">';
                } else {
                    echo '<i class="' . htmlspecialchars($siteLogo) . ' mr-2"></i>';
                }
                echo htmlspecialchars($siteName);
                ?>
            </div>
            <button id="closeMobileMenu" class="text-3xl text-text-dark" aria-label="Close menu">&times;</button>
        </div>
        <nav class="space-y-4">
            <a href="<?php echo $base_url; ?>home" class="block p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150">🏠 Home</a>
            <a href="<?php echo $base_url; ?>category?cat=news" class="block p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150">📰 News</a>
            <a href="<?php echo $base_url; ?>category?cat=articles" class="block p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150">📄 Articles</a>
            <a href="<?php echo $base_url; ?>category?cat=journals" class="block p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150">📚 Journals</a>
            <a href="<?php echo $base_url; ?>surveys.php" class="block p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150">📊 Surveys</a>
            <?php if (isLoggedIn()): ?>
                <?php if (basename($_SERVER['SCRIPT_NAME']) !== 'home.php'): ?>
                <button type="button" class="block w-full text-left p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150" data-bs-toggle="modal" data-bs-target="#cartModal">
                    🛒 Cart
                    <?php if ($cartCount > 0): ?>
                        <span class="ml-2 bg-red-500 text-white text-xs px-2 py-1 rounded-full"><?php echo $cartCount; ?></span>
                    <?php endif; ?>
                </button>
                <?php endif; ?>
                <?php if (basename($_SERVER['SCRIPT_NAME']) !== 'home.php'): ?>
                    <a href="<?php echo $base_url; ?>profile.php" class="block p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150">👤 Profile</a>
                <?php endif; ?>
                <?php if (hasRole('admin')): ?>
                    <a href="<?php echo $base_url; ?>admin/dashboard.php" class="block p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150">⚙️ Admin Dashboard</a>
                <?php elseif (hasRole('instructor')): ?>
                    <a href="<?php echo $base_url; ?>instructor/dashboard.php" class="block p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150">👨‍🏫 Instructor Dashboard</a>
                <?php else: ?>
                    <?php renderStudentDashboardLink($base_url, 'block p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150'); ?>
                <?php endif; ?>
                <a href="<?php echo $base_url; ?>logout.php" class="block p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150">🚪 Logout</a>
            <?php else: ?>
                <a href="<?php echo $base_url; ?>login.php" class="block p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150">🔐 Login</a>
            <?php endif; ?>
        </nav>
    </div>

    <main class="main">
